% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sweater.R
\name{weat_exact}
\alias{weat_exact}
\alias{weat_resampling}
\title{Test of significance for WEAT}
\usage{
weat_exact(x)

weat_resampling(x, n_resampling = 9999)
}
\arguments{
\item{x}{an object from the \link{weat} function.}

\item{n_resampling}{an integer specifying the number of replicates used to estimate the exact test}
}
\value{
A list with class \code{"htest"}
}
\description{
This function conducts the test of significance for WEAT as described in Caliskan et al. (2017). The exact test (proposed in Caliskan et al.) takes an unreasonably long time, if the total number of words in S and T is larger than 10. The resampling test is an approximation of the exact test.
}
\examples{
# Reproduce the number in Caliskan et al. (2017) - Table 1, "Math vs. Arts"
data(glove_math)
S1 <- c("math", "algebra", "geometry", "calculus", "equations",
"computation", "numbers", "addition")
T1 <- c("poetry", "art", "dance", "literature", "novel", "symphony", "drama", "sculpture")
A1 <- c("male", "man", "boy", "brother", "he", "him", "his", "son")
B1 <- c("female", "woman", "girl", "sister", "she", "her", "hers", "daughter")
sw <- weat(glove_math, S1, T1, A1, B1)
weat_resampling(sw)
}
\references{
Caliskan, A., Bryson, J. J., & Narayanan, A. (2017). Semantics derived automatically from language corpora contain human-like biases. Science, 356(6334), 183-186. \doi{10.1126/science.aal4230}
}
