% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randpicks_convert.R
\name{randpicks_convert}
\alias{randpicks_convert}
\title{Convert randpicks file}
\usage{
randpicks_convert(x.randpicks, x.segdata, seg.km)
}
\arguments{
\item{x.randpicks}{Data frame with two columns;
randpick values formatted for segchopr that correspond to \code{x.segdata}}

\item{x.segdata}{Data frame; segdata that corresponds to \code{x.randpicks}}

\item{seg.km}{numeric; target segment length used when creating \code{x.segdata}}
}
\value{
Data frame with one line for each continuous effort section in \code{x.segdata},
  and two columns: \code{effort_section} and \code{randpicks}
}
\description{
Convert randpicks file from segchopr format to swfscDAS format
}
\details{
Past DAS processing code (segchopr) only recorded the generated random values,
  whereas swfscDAS randpicks files contain one line for each continuous effort section.
  See \code{\link{das_chop_equallength}} for more details about the swfscDAS randpicks format.
  This function 'converts' a randpicks data frame generated by segchopr
  to a data frame that meets the swfscDAS randpicks format requirements
}
