% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/action_functions.R
\name{copy_files_to_right}
\alias{copy_files_to_right}
\title{Copy files from left to right directory}
\usage{
copy_files_to_right(left_dir, right_dir, files_to_copy, recurse = TRUE)
}
\arguments{
\item{left_dir}{Path of the source directory (left/leader).}

\item{right_dir}{Path of the destination directory (right/follower).}

\item{files_to_copy}{Data frame containing paths of files to copy and their synchronization status.}

\item{recurse}{Logical, default is TRUE.
\itemize{
\item If TRUE: Files are copied into corresponding sub-directories in the destination folder. If a subdirectory doesn't exist in the destination, it will be created.
\item If FALSE: Files are copied to the top level of the destination directory.
}}
}
\value{
Invisible TRUE upon successful completion of the file copying process.
}
\description{
This function copies files from a source directory (left_dir) to a destination directory (right_dir) based on a provided data frame containing file paths and synchronization status.
}
\details{
The function performs the following steps:
\enumerate{
\item Checks if the source and destination directories exist and creates the destination directory if it doesn't already exist.
\item Copies files from the source directory to the corresponding subdirectory in the destination directory based on the provided file paths.
}
}
\keyword{internal}
