% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabcoxph.R
\name{tabcoxph}
\alias{tabcoxph}
\title{Create Summary Table for Fitted Cox Proportional Hazards Model}
\usage{
tabcoxph(
  fit,
  columns = c("beta.se", "hr.ci", "p"),
  var.labels = NULL,
  factor.compression = 1,
  sep.char = ", ",
  decimals = 2,
  formatp.list = NULL
)
}
\arguments{
\item{fit}{Fitted \code{\link[survival]{coxph}} object.}

\item{columns}{Character vector specifying what columns to include. Choies
for each element are \code{"events"}, \code{"beta"}, \code{"se"},
\code{"beta.se"}, \code{"beta.betaci"}, \code{"betaci"}, \code{"hr"},
\code{"hr.hrci"}, \code{"hrci"}, \code{"z"}, and \code{"p"}.}

\item{var.labels}{Named list specifying labels to use for certain predictors.
For example, if \code{fit} includes a predictor named "race"
that you want to label "Race/ethnicity" and a predictor named "age_yrs" that
you want to label "Age (years)", use
\code{var.labels = list(race = "Race/ethnicity", age_yrs = "Age (years)"}.}

\item{factor.compression}{Integer value from 1 to 5 controlling how much
compression is applied to factor predictors (higher value = more
compression). If 1, rows are Variable, Level 1 (ref), Level 2, ...; if 2,
rows are Variable (ref = Level 1), Level 2, ...; if 3, rows are Level 1
(ref), Level 2, ...; if 4, rows are Level 2 (ref = Level 1), ...; if 5, rows
are Level 2, ...}

\item{sep.char}{Character string with separator to place between lower and
upper bound of confidence intervals. Typically \code{"-"} or \code{", "}.}

\item{decimals}{Numeric value specifying number of decimal places for numbers
other than p-values.}

\item{formatp.list}{List of arguments to pass to \code{\link[tab]{formatp}}.}
}
\value{
\code{\link[knitr]{kable}}.
}
\description{
Creates a table summarizing a GEE fit using the \code{\link[survival]{coxph}}
function.
}
\examples{
# Cox PH model with age, sex, race, and treatment
library("survival")
fit <- coxph(
  Surv(time = time, event = delta) ~ Age + Sex + Race + Group,
  data = tabdata
)
tabcoxph(fit)

# Can also use piping
fit \%>\% tabcoxph()

# Same as previous, but with custom labels for Age and Race and factors
# displayed in slightly more compressed format
fit \%>\%
  tabcoxph(
    var.labels = list(Age = "Age (years)", Race = "Race/ethnicity"),
    factor.compression = 2
  )

# Cox PH model with some higher-order terms
fit <- coxph(
  Surv(time = time, event = delta) ~
  poly(Age, 2, raw = TRUE) + Sex + Race + Group + Race*Group,
  data = tabdata
)
fit \%>\% tabcoxph()


}
\references{
1. Therneau, T. (2015). A Package for Survival Analysis in S. R package
version 2.38. \url{https://cran.r-project.org/package=survival}.

2. Therneau, T.M. and Grambsch, P.M. (2000). Modeling Survival Data:
Extending the Cox Model. Springer, New York. ISBN 0-387-98784-3.
}
