% Auto-generated documentation for function update.prTable 
%  2024-01-26 15:48:14.415102 
\name{update.prTable}
\alias{update.prTable}
\title{Update a \code{prtable} (Plot-Ready Table) Object }
\description{
Update a \code{prTable} object with new entry, block, or hvrule styles,
and/or new scale.  This is an internal utility function, not intended to
be called directly by package users.
}
\usage{
\method{update}{prTable}(object, entryStyle=NULL, blockStyle=NULL, hvruleStyle=NULL, 
    scale=NULL, ...)
}
\arguments{
  \item{object}{A \code{prTable} object, a plot-ready table.
  }
  \item{entryStyle, blockStyle, hvruleStyle}{Optional \code{styleObj} objects, specifying new styles for assigning
graphical properties to table entries, blocks, or hvrules.  The default
value of NULL leaves the corresponding style of \code{object} unchanged.
  }
  \item{scale}{Optional numeric multiplier used to increase or decrease the displayed
size of table elements, relative to the natural size implied by their
(possibly updated) styles.  If it has length two, the first element
applies to entries and blocks, and the second to hvrules.  The default is
to use the existing scale value(s) in \code{object}.
  }
  \item{...}{Ignored, with a warning.  (Included for compatibility with the generic.)
  }
}
\value{
An object of S3 class \code{prTable}, a plot-ready table.  See
\code{prTable.prEntries} for the structure of this object.
}
\details{
The \code{enabled} field is not changed for any entries, blocks, or
existing hvrules.  (Changing \code{enabled} for entries could have
cascading effects on blocks and hvrules.)

When argument \code{hvruleStyle} is provided, hvrules are regenerated by
applying the style to the \code{blocks} component of \code{object}.  These
new hvrules replace any existing hvrules with the same ID.  However
existing hvrules with other ID's are left unchanged.

Users should generally update \code{pltdTable} objects, not \code{prTable}
objects.
}
\seealso{
\code{\link{styleObj}}, \code{\link{prTable.prEntries}}
}
\keyword{internal}
