% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{DiversityIndex-class}
\alias{DiversityIndex-class}
\alias{.DiversityIndex}
\title{Diversity Index}
\description{
An S4 class to represent a diversity measure.
}
\section{Slots}{

\describe{
\item{\code{.Data}}{A \code{\link{numeric}} vector of diversity measures.}

\item{\code{labels}}{A \code{\link{character}} vector giving the sample names.}

\item{\code{size}}{An \code{\link{integer}} vector giving the sample sizes.}

\item{\code{data}}{A \code{\link{numeric}} matrix of count data.}

\item{\code{method}}{A \code{\link{character}} string specifying the method used.}

\item{\code{simulation}}{A four columns \code{\link{numeric}} matrix giving the diversity
measures for the simulated assemblage (sample \code{size}, \code{mean} estimate,
\code{lower} and \code{upper} boundaries of the confidence interval).}

\item{\code{seed}}{A \code{\link{numeric}} vector giving the value of \link{.Random.seed} before the
simulation was started; otherwise it is the user specified value with a
\code{kind} attribute with value \verb{as.list(}\code{\link[=RNGkind]{RNGkind()}}\verb{)}.}
}}

\note{
This class inherits from base \code{\link{numeric}}.
}
\section{Coerce}{

In the code snippets below, \code{x} is an \code{DiversityIndex} object.
\describe{
\item{\code{as.data.frame(x)}}{Coerces to a \code{\link{data.frame}}.}
}
}

\seealso{
Other classes: 
\code{\link{CompositionIndex-class}},
\code{\link{EvennessIndex-class}},
\code{\link{HeterogeneityIndex-class}},
\code{\link{RarefactionIndex-class}},
\code{\link{RichnessIndex-class}}
}
\author{
N. Frerebeau
}
\concept{classes}
\keyword{internal}
