% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab.R
\name{tab}
\alias{tab}
\title{Efficient tabulation}
\usage{
tab(df, ..., by, round)
}
\arguments{
\item{df}{A data.table, tibble, or data.frame.}

\item{...}{A column or set of columns (without quotation marks).}

\item{by}{A variable by which you want to group observations before tabulating (without quotation marks).}

\item{round}{An integer indicating the number of digits for proportion and cumulative proportion.}
}
\value{
Tabulation (frequencies, proportion, cumulative proportion) for each unique value of the variables given in \code{...} from \code{df}.
}
\description{
Produces a tabulation: for each unique group from the variable(s),
\code{tab} shows the number of
	observations with that value, proportion of observations with that
		value, and cumulative proportion, in descending order of frequency.
		Accepts data.table, tibble, or data.frame as input.
Efficient with big data: if you give it a \code{data.table},
		\code{tab} uses \code{data.table} syntax.
}
\examples{
# data.table
library(data.table)
library(magrittr)
a <- data.table(varname = sample.int(20, size = 1000000, replace = TRUE))
a \%>\% tab(varname)

# tibble
library(dplyr)
b <- tibble(varname = sample.int(20, size = 1000000, replace = TRUE))
b \%>\% tab(varname, round = 1)

# data.frame
c <- data.frame(varname = sample.int(20, size = 1000000, replace = TRUE))
c \%>\% tab(varname)

}
