% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothPalette.R
\name{smoothPalette}
\alias{smoothPalette}
\title{Replace a vector of numbers by a gradient of colors}
\usage{
smoothPalette(
  x,
  pal = NULL,
  max = NULL,
  min = NULL,
  n = 9,
  palfunc = NULL,
  na.color = "white"
)
}
\arguments{
\item{x}{A numeric vector}

\item{pal}{Character vector containing the color gradient onto which the
numeric vector \code{x} will be mapped. By default, a gradient from white to
black is generated. If it is a single character value, it will be treated as
name of an RColorBrewer palette.}

\item{max}{Values of \code{x} larger than \code{max} will be replaced by
\code{max}
\code{max}}

\item{min}{Values of \code{x} smaller than \code{min} will be replaced by
\code{min}}

\item{n}{Number of steps}

\item{palfunc}{Palette function returned by colorRampPalette}

\item{na.color}{NA values will be replaced by that color}
}
\value{
A character vector of the same length as the numeric vector
\code{x}, containing the matching colors.
}
\description{
Replace a vector of numbers by a vector of colors from a palette, such that
values correspond to the colors on a smooth gradient.
}
\details{
This function is used to map a continues numerical vector on an ordinal
character vector, in especially a vector of colors. Color palette can be
specified using an RColorBrewer palette name.
}
\examples{

smoothPalette( 1:3 )
# will print:
# "#CCCCCC" "#666666" "#000000"

smoothPalette( 1:3, pal= "Blues" )
# will produce:
# "#F7FBFF" "#6BAED6" "#08306B"

x <- runif( 100 )
plot( 1:100, x, col= smoothPalette( x, pal= "BrBG" ), pch= 19 )

}
\seealso{
\code{\link{tagcloud}}

\link[RColorBrewer]{brewer.pal}
}
\author{
January Weiner <january.weiner@gmail.com>
}
\keyword{mapping}
\keyword{palette}
