% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Other.R
\name{dataEUROSTOXX}
\alias{dataEUROSTOXX}
\title{EUROSTOXX50 weekly negative log-returns.}
\format{
\code{dataEUROSTOXX} is a matrix with 711 rows and 10 columns.
}
\source{
Yahoo Finance
}
\description{
The first three columns represent the weekly negative log-returns of the index prices
of the EUROSTOXX50 and of its subindices correspoding to the supersectors chemicals and insurance.
The fourth and fifth columns represent the weekly negative log-returns of the index prices of
the DAX and the CAC40 indices.
The sixth to tenth columnds represent the weekly negative log-returns of the stock prices of Bayer,
BASF, Allianz, AXA, and Airliquide respectively.
}
\examples{
data(dataEUROSTOXX)
## Transform data to unit Pareto margins
n <- nrow(dataEUROSTOXX)
x <- apply(dataEUROSTOXX, 2, function(i) n/(n + 0.5 - rank(i)))
## Define indices in which we evaluate the estimator
indices <- selectGrid(c(0,0.5,1), d = 10, nonzero = c(2,3))
start <- c(0.67,0.8,0.77,0.91,0.41,0.47,0.25,0.7,0.72,0.19,0.37,0.7,0.09,0.58)
## Estimate the parameters. Lasts up to ten minutes.
\donttest{
EstimationMaxLinear(x, indices, k = 40, method = "WLS", startingValue = start,
covMat = FALSE, EURO = TRUE)
}
}
\references{
Einmahl, J.H.J., Kiriliouk, A., and Segers, J. (2018). A continuous updating weighted least squares estimator of tail dependence in high dimensions. Extremes 21(2), 205-233.
}
