% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform-smd.R
\name{smd_contingency}
\alias{smd_contingency}
\title{Create a contingency table with SMD given a row column of a formula}
\usage{
smd_contingency(
  table,
  row,
  column,
  cell_style,
  style,
  smdformat = NULL,
  collapse_single = TRUE,
  weight = NULL,
  test = FALSE,
  pformat = NULL,
  ...
)
}
\arguments{
\item{table}{The tablebuilder object}

\item{row}{The row node from the parser of the formula}

\item{column}{The column node provided by the parser of the formula}

\item{cell_style}{A list of all individual cell stylings to apply}

\item{style}{The global style to apply.}

\item{smdformat}{The format command to apply to smd}

\item{collapse_single}{Should single factor variables be collapsed}

\item{weight}{Any weighting to apply to data for computation of SMD}

\item{test}{logical; include statistical test results}

\item{pformat}{numeric, character or function; A formatting directive to be applied to p-values}

\item{...}{Additional arguments to provide cell generation functions}
}
\value{
The resulting sub table constructed
}
\description{
Create a contingency table with SMD given a row column of a formula
}
