% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_concept.R
\name{add_concept}
\alias{add_concept}
\alias{add_concept,taxlist,data.frame-method}
\alias{add_concept,taxlist,character-method}
\alias{add_concept,taxlist,taxlist-method}
\alias{update_concept}
\title{Add new taxonomic concepts into taxlist objects}
\usage{
add_concept(taxlist, TaxonName, ...)

\S4method{add_concept}{taxlist,data.frame}(taxlist, TaxonName, ...)

\S4method{add_concept}{taxlist,character}(taxlist, TaxonName, ...)

\S4method{add_concept}{taxlist,taxlist}(taxlist, TaxonName, insert_view = FALSE, ...)

update_concept(taxlist, ConceptID, ...)
}
\arguments{
\item{taxlist}{A \linkS4class{taxlist} object.}

\item{TaxonName}{Character vector with the accepted name for the new taxon
concepts.}

\item{...}{Further arguments passed among methods.}

\item{insert_view}{A numeric (integer) vector, indicating the views to be
inserted in \code{taxlist} or the value \code{TRUE} (see details).}

\item{ConceptID}{Concept IDs to be updated.}
}
\description{
Alternative methods to add new concepts into existing \code{taxlist} objects.
}
