% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poppk_mods.R
\name{pkmod_eleveld_remi}
\alias{pkmod_eleveld_remi}
\title{Eleveld population PK model for remifentanil}
\usage{
pkmod_eleveld_remi(AGE, MALE, TBW, HGT = NULL, BMI = NULL, PD = TRUE, ...)
}
\arguments{
\item{AGE}{Age (years)}

\item{MALE}{Sex, logical}

\item{TBW}{Total body weight (kg).}

\item{HGT}{Height (cm). Used to calculate BMI if not provided.}

\item{BMI}{Body mass index}

\item{PD}{Logical. Should PD parameters be returned in addition to PK parameters.}

\item{...}{Arguments passed to `pkmod`}
}
\value{
`pkmod` object with Eleveld remifentanil population PK or PK-PD parameters
}
\description{
Function takes patient covariate values required for the Eleveld
PK or PK-PD model for propofol and returns a `pkmod` object with the appropriate model
parameters.
}
\examples{
pkmod_eleveld_remi(AGE = 40,TBW = 56,HGT=150,MALE = TRUE)
}
