% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.kw.R
\name{calc.kw}
\alias{calc.kw}
\title{Calculate Kernel weights}
\usage{
calc.kw(X, x0, span = 0.1, h = NULL, type = "uniform")
}
\arguments{
\item{X}{the vector of biomarker values from other subjects used to calculate the weights around the center x0.}

\item{x0}{a scalar as the center around which the kernel weights are calculated.}

\item{span}{a numeric value of the proportion of neighbour observations used, default is 0.1.}

\item{h}{a numeric value of the bandwidth of kernel weights, defualt is NULL. If not specified, the function used the value of \code{span} to calculate weights.
If both \code{span} and \code{h} are specified, the function will ignore the span and used bandwidth of kernel function instead.}

\item{type}{a character value of the type of kernel function used to calculate kernel weights. Default is "uniform" kernel. Other options are "Epanichnekov" and "normal".
It will only be used when the bandwidth \code{h} is specified.}
}
\value{
Return a vector of kernel weights for each element in X. It has the same length as X.
}
\description{
This function calculate the nearest neighbor kernel weights using uniform kernel weights.
}
\note{
X must be the vector of ALL risk score values in the data; it cannot
      be any other vector of arbitrary length.
}
\keyword{internal}
