% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/td.kw.cr.R
\name{td.kw.cr}
\alias{td.kw.cr}
\title{Calculate conditional probability of being a case at time tau}
\usage{
td.kw.cr(
  X,
  Y,
  delta,
  event.code,
  tau,
  span = 0.1,
  h = NULL,
  type = "uniform",
  epsilon = 0.01
)
}
\arguments{
\item{X}{a numeric vector of risk score for each subject. Higher value of \code{X} indicates higher risk of the event.
It can be biomarker, a function of multiple biomarker, or predicted cumulative incidence function by other methods.
Same length with \code{Y} and \code{delta}.}

\item{Y}{a numeric vector of time to event. Same length with \code{X} and \code{delta}.}

\item{delta}{a vector of numeric indicator of event type. The primary event you want to study should be coded as 1,
the competing event should be coded as 2, and censoring should be coded as 0. Same length with \code{X} and \code{Y}.}

\item{event.code}{numeric indicator of event (1), or competing event (2), it specifies you are going to calculate the
conditional probability for which event.}

\item{tau}{a scalar, the prediction horizon at which the prediction is evaluated.}

\item{span}{a numeric value, the proportion of neighbour observations used in nearest neighbor method, default is 0.1.}

\item{h}{a numeric value, the bandwidth of kernel weights, defualt is \code{NULL}. If not specified, the function will use the value of
\code{span} to calculate kernel weights. In case both \code{span} and \code{h} are specified, the function will use \code{h}.}

\item{type}{a character value, indicating the type of kernel function used to calculate kernel weights. Default is "\code{uniform}" kernel.
Other options are "\code{Epanechnikov}" and "\code{normal}".}

\item{epsilon}{the precision parameter for weight calculation using neighborhood approximation. If not specified, default will be
calculating weights for all right censored points individually.}
}
\value{
Returns the estimated conditional probability of being a case at time tau for the specified event code.
}
\description{
This is key function to estimate the weight, the conditional probability of being a case at time tau
 given the observed time to event, event status, and prognostic risk score, as described in Wu and Li, 2018.
}
\details{
This function read in the risk score value \code{X}, the time-to-event data \code{Y} and censoring indicator \code{delta}
       to estimate the weight, the conditional probability of being a case at time tau when there is competing event.
       The weight estimation serves for the further prediction accuracy estimation, including AUC, Brier score and so on.
}
\seealso{
\code{\link[survival]{survfit}}
}
\keyword{internal}
