% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdsc.R
\name{tdsc}
\alias{tdsc}
\title{Time Domain Signal Coding}
\usage{
tdsc(wave, lag = 1L, coding_matrix = NULL, plot = FALSE, max_D = 25L)
}
\arguments{
\item{wave}{A Wave object}

\item{lag}{The lag used to create the A-matrix}

\item{coding_matrix}{A matrix used to code the Duration-Shape pairs}

\item{plot}{If TRUE plots the workings of the coding algorithm}

\item{max_D}{The maximum Duration to code}
}
\description{
Performs Time Domain Signal Coding on a Wave object calculating the S-matrix and  A-matrix.
}
\examples{
library(tuneR)
wave <- readWave(system.file("extdata", "1.wav", package="tdsc"))
t <- tdsc(wave)
t <- tdsc(wave, lag=2, max_D=10)
}
\keyword{TDSC}
