% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_table_args.R
\name{resolve_basic_table_args}
\alias{resolve_basic_table_args}
\title{Resolves and reduces multiple \code{basic_table_args} objects}
\usage{
resolve_basic_table_args(
  user_table = basic_table_args(),
  user_default = basic_table_args(),
  module_table = basic_table_args(),
  app_default = getOption("teal.basic_table_args", basic_table_args())
)
}
\arguments{
\item{user_table}{(\code{basic_table_args})\cr
end user setup for \code{\link[rtables:basic_table]{rtables::basic_table()}} of a specific table.
Created with the \code{\link[=basic_table_args]{basic_table_args()}} function. The \code{NULL} value is supported.}

\item{user_default}{(\code{basic_table_args})\cr
end user default setup for \code{\link[rtables:basic_table]{rtables::basic_table()}}
of a specific table. Created with the \code{\link[=basic_table_args]{basic_table_args()}} function. The \code{NULL} value is supported.}

\item{module_table}{(\code{ggplot2_args})\cr
module creator setup for \code{\link[rtables:basic_table]{rtables::basic_table()}} of a specific table.
Created with the \code{\link[=basic_table_args]{basic_table_args()}} function. The \code{NULL} value is supported.}

\item{app_default}{(\code{basic_table_args})\cr
Application level setting. Can be \code{NULL}.}
}
\value{
\code{basic_table_args} object.
}
\description{
Resolving and reducing multiple \code{basic_table_args} objects.
This function is intended to utilize user provided settings, defaults provided by the module creator and
also \code{teal} option. See \code{Details}, below, to understand the logic.
}
\details{
The function picks the first non \code{NULL} value for each argument, checking in the following order:
\enumerate{
\item \code{basic_table_args} argument provided by the end user.
Per table (\code{user_table}) and then default (\code{user_default}) setup.
\item \code{app_default} global R variable, \code{teal.basic_table_args}.
\item \code{module_table} which is a module creator setup.
}
}
\examples{
resolve_basic_table_args(
  user_table = basic_table_args(title = "TITLE"),
  user_default = basic_table_args(title = "DEFAULT_TITLE", subtitles = "SUBTITLE")
)
}
\seealso{
\code{\link[=parse_basic_table_args]{parse_basic_table_args()}} to parse resolved list into list of calls.
}
