% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trigonometry_degrees.R
\name{shortest_distance_to_line}
\alias{shortest_distance_to_line}
\title{Shortest distance between pairs of geometries}
\usage{
shortest_distance_to_line(x, line, ellipsoidal = FALSE)
}
\arguments{
\item{x, line}{objects of class \code{sfg}, \code{sfc} or \code{sf}}

\item{ellipsoidal}{Logical. Whether the distance is calculated using
spherical distances (\code{\link[sf:geos_measures]{sf::st_distance()}}) or
ellipsoidal distances (\code{lwgeom::st_geod_distance()}).}
}
\value{
numeric. Shortest distance in meters
}
\description{
The shortest Great Circle distance between pairs of geometries
}
\examples{
plate_boundary <- subset(plates, plates$pair == "na-pa")
shortest_distance_to_line(san_andreas, plate_boundary) |>
  head()
}
