% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute.R
\name{get_mnpp}
\alias{get_mnpp}
\title{Get the MNPP for the Step 2 model}
\usage{
get_mnpp(z, data, step2, Trt, Y, threshold)
}
\arguments{
\item{z}{a numeric vector of estimated CATEs from Step 1}

\item{data}{a data frame containing a response, binary treatment indicators,
and covariates.}

\item{step2}{a character string specifying the Step 2 model. Supports
"\code{lasso}", "\code{rtree}",  "\code{classtree}", or "\code{ctree}".}

\item{Trt}{a string specifying the name of the column of \code{data}
contains the treatment indicators.}

\item{Y}{a string specifying the name of the column of \code{data}
contains the response.}

\item{threshold}{for "\code{step2 = 'classtree'}" only. The value against
which to test if the estimated individual treatment effect from Step 1 is
higher (TRUE) or lower (FALSE).}
}
\description{
Find the lowest penalty parameter so that the Step 2 model fit for the
estimated CATE from Step 1 is constant for all subjects.
}
