% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_2.R
\name{vt2_classtree}
\alias{vt2_classtree}
\title{Estimate the CATE using a classification tree for Step 2}
\usage{
vt2_classtree(z, data, Trt, Y, theta, threshold)
}
\arguments{
\item{z}{a numeric vector of estimated CATEs from Step 1}

\item{data}{a data frame containing a response, binary treatment indicators,
and covariates.}

\item{Trt}{a string specifying the name of the column of \code{data}
contains the treatment indicators.}

\item{Y}{a string specifying the name of the column of \code{data}
contains the response.}

\item{theta}{tree complexity parameter (\code{cp})}

\item{threshold}{for "\code{step2 = 'classtree'}" only. The value against
which to test if the estimated individual treatment effect from Step 1 is
higher (TRUE) or lower (FALSE).}
}
\value{
an object of class \code{rpart}. See
\code{\link[rpart]{rpart.object}}.
}
\description{
Estimate the CATE using a classification tree for Step 2
}
\seealso{
Other VT Step 2 functions: 
\code{\link{vt2_ctree}()},
\code{\link{vt2_lasso}()},
\code{\link{vt2_rtree}()}
}
\concept{VT Step 2 functions}
