% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_templateICA.R
\name{EM_templateICA}
\alias{EM_templateICA}
\alias{EM_templateICA.spatial}
\alias{EM_templateICA.independent}
\title{EM Algorithms for Template ICA Models}
\usage{
EM_templateICA.spatial(
  template_mean,
  template_var,
  meshes,
  BOLD,
  theta0,
  C_diag,
  H,
  Hinv,
  maxiter = 100,
  usePar = FALSE,
  epsilon = 0.001,
  reduce_dim = TRUE,
  verbose = FALSE
)

EM_templateICA.independent(
  template_mean,
  template_var,
  BOLD,
  theta0,
  C_diag,
  H,
  Hinv,
  maxiter = 100,
  epsilon = 0.001,
  reduce_dim = FALSE,
  usePar = FALSE,
  verbose
)
}
\arguments{
\item{template_mean}{(\eqn{V \times Q} matrix) mean maps for each IC in template,
where \eqn{Q} is the number of ICs, \eqn{V=nvox} is the number of data locations.}

\item{template_var}{(\eqn{V \times Q} matrix) between-subject variance maps
for each IC in template}

\item{meshes}{\code{NULL} for spatial independence model, otherwise a list of
objects of class "templateICA_mesh" containing the triangular mesh (see
\code{\link{make_mesh}}) for each brain structure.}

\item{BOLD}{(\eqn{V \times Q} matrix) dimension-reduced fMRI data}

\item{theta0}{(list) initial guess at parameter values: A (\eqn{QxQ} mixing matrix),
nu0_sq (residual variance from first level) and (for spatial model only)
kappa (SPDE smoothness parameter for each IC map)}

\item{C_diag}{(\eqn{Qx1}) diagonal elements of matrix proportional to
residual variance.}

\item{H, Hinv}{For dimension reduction
of the spatial template ICA model, which assumes that all IC's have the
same smoothness parameter, \eqn{\kappa}}

\item{maxiter}{Maximum number of EM iterations. Default: 100.}

\item{usePar}{Parallelize the computation? Default: \code{FALSE}. Can be the
number of cores to use or \code{TRUE}, which will use the number available minus two.
Not yet implemented for spatial template ICA.}

\item{epsilon}{Smallest proportion change between iterations. Default: 0.001.}

\item{reduce_dim}{Reduce the temporal dimension of the data using PCA?
Default: \code{TRUE} for the spatial EM algorithm, and \code{FALSE} for the
independent EM algorithm.}

\item{verbose}{If \code{TRUE}, display progress of algorithm. Default: \code{FALSE}.}
}
\value{
A list: theta (list of final parameter estimates), subICmean
(estimates of subject-level ICs), subICvar (variance of subject-level ICs,
for non-spatial model) or subjICcov (covariance matrix of subject-level ICs,
for spatial model -- note that only diagonal and values for neighbors are
computed), and success (flag indicating convergence (\code{TRUE}) or not
(\code{FALSE}))
}
\description{
EM Algorithms for Template ICA Models
}
\details{
\code{EM_templateICA.spatial} implements the expectation-maximization
(EM) algorithm described in Mejia et al. (2019+) for estimating the
subject-level ICs and unknown parameters in the template ICA model with
spatial priors on subject effects.

In both models, if original fMRI timeseries has covariance
\eqn{\sigma^2 I_T}, the prewhitened timeseries achieved by premultiplying
by (\eqn{QxT}) matrix \eqn{H} from PCA has diagonal covariance
\eqn{\sigma^2HH'}, so C_diag is \eqn{diag(HH')}.
}
