% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_tensor.R
\name{atrans}
\alias{atrans}
\title{Tucker product.}
\usage{
atrans(A, B)
}
\arguments{
\item{A}{An array of dimension \eqn{K}.}

\item{B}{A list of matrices of length \eqn{K}. It must be that
\code{ncol(B[[k]]) == dim(A)[k]}.}
}
\description{
Performs the Tucker product between an array and a list of matrices.
}
\details{
The Tucker product between a list of matrices \code{B} and an array \code{A}
is formally equivalent to performing the \eqn{k}-mode product between
\code{A} and each list element in \code{B}. For example, if the dimension of
\code{A} is three, then \code{atrans(A,B) =
amprod(amprod(amprod(A,B[[1]],1),B[[2]],2),B[[3]],3)}.  The ordering of this
\eqn{k}-mode product does not matter. See Kolda and Bader (2009) for
details.
}
\examples{
A <- array(1:8, dim = c(2,2,2))
B <- list()
B[[1]] <-matrix(1:4, nrow = 2)
B[[2]] <- matrix(1:6, nrow = 3)
B[[3]] <- matrix(1:2, nrow = 1)
atrans(A,B)
}
\references{
\itemize{
  \item{Kolda, T. G., & Bader, B. W. (2009). Tensor decompositions and applications. \emph{SIAM review}, 51(3), 455-500. \doi{10.1137/07070111X}}
}
}
\seealso{
\code{\link{amprod}} for multiplying one matrix along one mode of an
  array.
}
\author{
Peter Hoff.
}
