% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testex.R
\name{testex}
\alias{testex}
\title{A syntactic helper for writing quick and easy example tests}
\usage{
testex(
  ...,
  srcref = NULL,
  example_srcref = NULL,
  value = get_example_value(),
  envir = parent.frame(),
  style = "standalone"
)
}
\arguments{
\item{...}{Expressions to evaluated. \code{.} will be replaced with the
expression passed to \code{val}, and may be used as a shorthand for the
last example result.}

\item{srcref}{An option \code{srcref_key} string used to indicate where the
relevant test code originated from.}

\item{example_srcref}{An option \code{srcref_key} string used to indicate where
the relevant example code originated from.}

\item{value}{A value to test against. By default, this will use the example's
\code{.Last.value}.}

\item{envir}{An environment in which tests should be evaluated. By default
the parent environment where tests are evaluated.}

\item{style}{A syntactic style used by the test. Defaults to \code{"standalone"},
which expects \code{TRUE} and uses a \code{.}-notation. Accepts one of
\code{"standalone"} or \code{"testthat"}. By default, styles will be implicitly
converted to accommodate known testing frameworks, though this can be
disabled by passing the style \code{"AsIs"} with \code{\link[=I]{I()}}.}
}
\value{
Invisibly returns the \code{.Last.value} as it existed prior to evaluating
the test.
}
\description{
A wrapper around \code{stopifnot} that allows you to use \code{.} to refer to
\code{.Last.value} and preserve the last non-test output from an example.
}
\section{Documenting with \code{testex}}{


\code{testex} is a simple wrapper around execution that propagates the
\code{.Last.value} returned before running, allowing you to chain tests
more easily.
\subsection{Use in \code{Rd} files:}{

\preformatted{
\examples{
  f <- function(a, b) a + b
  f(3, 4)
  \testonly{
    testex::testex(
      is.numeric(.),
      identical(., 7)
    )
  }
}
}

But \code{Rd} files are generally regarded as being a bit cumbersome to author
directly. Instead, \code{testex} provide helpers that generate this style of
documentation, which use this function internally.
}

\subsection{Use with \code{roxygen2}}{

Within a \code{roxygen2} \verb{@examples} block you can instead use the \verb{@test} tag
which will generate Rd code as shown above.

\preformatted{
#' @examples
#' f <- function(a, b) a + b
#' f(3, 4)
#' @test is.numeric(.)
#' @test identical(., 7)
}
}
}

