% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skip.R
\name{skip}
\alias{skip}
\alias{skip_if_not}
\alias{skip_if}
\alias{skip_if_not_installed}
\alias{skip_unless_r}
\alias{skip_if_offline}
\alias{skip_on_cran}
\alias{local_on_cran}
\alias{skip_on_os}
\alias{skip_on_ci}
\alias{skip_on_covr}
\alias{skip_on_bioc}
\alias{skip_if_translated}
\title{Skip a test for various reasons}
\usage{
skip(message = "Skipping")

skip_if_not(condition, message = NULL)

skip_if(condition, message = NULL)

skip_if_not_installed(pkg, minimum_version = NULL)

skip_unless_r(spec)

skip_if_offline(host = "captive.apple.com")

skip_on_cran()

local_on_cran(on_cran = TRUE, frame = caller_env())

skip_on_os(os, arch = NULL)

skip_on_ci()

skip_on_covr()

skip_on_bioc()

skip_if_translated(msgid = "'\%s' not found")
}
\arguments{
\item{message}{A message describing why the test was skipped.}

\item{condition}{Boolean condition to check. \code{skip_if_not()} will skip if
\code{FALSE}, \code{skip_if()} will skip if \code{TRUE}.}

\item{pkg}{Name of package to check for}

\item{minimum_version}{Minimum required version for the package}

\item{spec}{A version specification like '>= 4.1.0' denoting that this test
should only be run on R versions 4.1.0 and later.}

\item{host}{A string with a hostname to lookup}

\item{on_cran}{Pretend we're on CRAN (\code{TRUE}) or not (\code{FALSE}).}

\item{frame}{Calling frame to tie change to; expect use only.}

\item{os}{Character vector of one or more operating systems to skip on.
Supported values are \code{"windows"}, \code{"mac"}, \code{"linux"}, \code{"solaris"},
and \code{"emscripten"}.}

\item{arch}{Character vector of one or more architectures to skip on.
Common values include \code{"i386"} (32 bit), \code{"x86_64"} (64 bit), and
\code{"aarch64"} (M1 mac). Supplying \code{arch} makes the test stricter; i.e. both
\code{os} and \code{arch} must match in order for the test to be skipped.}

\item{msgid}{R message identifier used to check for translation: the default
uses a message included in most translation packs. See the complete list in
\href{https://github.com/wch/r-source/blob/master/src/library/base/po/R-base.pot}{\code{R-base.pot}}.}
}
\description{
\code{skip_if()} and \code{skip_if_not()} allow you to skip tests, immediately
concluding a \code{\link[=test_that]{test_that()}} block without executing any further expectations.
This allows you to skip a test without failure, if for some reason it
can't be run (e.g. it depends on the feature of a specific operating system,
or it requires a specific version of a package).

See \code{vignette("skipping")} for more details.
}
\section{Helpers}{

\itemize{
\item \code{skip_if_not_installed("pkg")} skips tests if package "pkg" is not
installed or cannot be loaded (using \code{requireNamespace()}). Generally,
you can assume that suggested packages are installed, and you do not
need to check for them specifically, unless they are particularly
difficult to install.
\item \code{skip_if_offline()} skips if an internet connection is not available
(using \code{\link[curl:nslookup]{curl::nslookup()}}) or if the test is run on CRAN. Requires
\{curl\} to be installed and included in the dependencies of your package.
\item \code{skip_if_translated("msg")} skips tests if the "msg" is translated.
\item \code{skip_on_bioc()} skips on Bioconductor (using the \code{IS_BIOC_BUILD_MACHINE}
env var).
\item \code{skip_on_cran()} skips on CRAN (using the \code{NOT_CRAN} env var set by
devtools and friends). \code{local_on_cran()} gives you the ability to
easily simulate what will happen on CRAN.
\item \code{skip_on_covr()} skips when covr is running (using the \code{R_COVR} env var).
\item \code{skip_on_ci()} skips on continuous integration systems like GitHub Actions,
travis, and appveyor (using the \code{CI} env var).
\item \code{skip_on_os()} skips on the specified operating system(s) ("windows",
"mac", "linux", or "solaris").
}
}

\examples{
if (FALSE) skip("Some Important Requirement is not available")

test_that("skip example", {
  expect_equal(1, 1L)    # this expectation runs
  skip('skip')
  expect_equal(1, 2)     # this one skipped
  expect_equal(1, 3)     # this one is also skipped
})
}
