% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_error.R
\name{ttm_expect_error}
\alias{ttm_expect_error}
\title{Test that multi: expect error}
\usage{
ttm_expect_error(object, info = NULL, label = NULL, verbose = 0)
}
\arguments{
\item{object}{Object to test.}

\item{info}{Passed to `testthat::expect_error()`.}

\item{label}{Passed to `testthat::expect_error()`.}

\item{verbose}{Amount of info that should be printed.}
}
\value{
Test result
}
\description{
See `testthat::expect_error` for details.
}
\examples{
set.seed(0)

# 1 attempt, all pass
ttm(1, {
  ttm_expect_error(stop('error'))
})

# Fails first ~10 times, then passes
ttm(100, {
  ttm_expect_error({
    print(1)
    if (runif(1) < 0.1) {
      stop('give error')
    }
  })
})

# Will always fail regardless of number of attempts
try({
  ttm(3, {
    ttm_expect_error(1 == 2)
  })
})
}
