% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_functions.R
\docType{data}
\name{count_functions}
\alias{count_functions}
\title{List of all feature counting functions}
\format{
Named list of all ferature counting functions
\describe{
\item{\code{n_words}}{Number of words.}
\item{\code{n_uq_words}}{Number of unique words.}
\item{\code{n_charS}}{Number of characters. Not counting urls, hashtags, mentions or white spaces.}
\item{\code{n_uq_charS}}{Number of unique characters. Not counting urls, hashtags, mentions or white spaces.}
\item{\code{n_digits}}{Number of digits.}
\item{\code{n_hashtags}}{Number of hashtags, word preceded by a '#'.}
\item{\code{n_uq_hashtags}}{Number of unique hashtags, word preceded by a '#'.}
\item{\code{n_mentions}}{Number of mentions, word preceded by a '@'.}
\item{\code{n_uq_mentions}}{Number of unique mentions, word preceded by a '@'.}
\item{\code{n_commas}}{Number of commas.}
\item{\code{n_periods}}{Number of periods.}
\item{\code{n_exclaims}}{Number of exclamation points.}
\item{\code{n_extraspaces}}{Number of times more then 1 consecutive space have been used.}
\item{\code{n_caps}}{Number of upper case characters.}
\item{\code{n_lowers}}{Number of lower case characters.}
\item{\code{n_urls}}{Number of urls.}
\item{\code{n_uq_urls}}{Number of unique urls.}
\item{\code{n_nonasciis}}{Number of non ascii characters.}
\item{\code{n_puncts}}{Number of punctuations characters, not including exclamation points, periods and commas.}
\item{\code{first_person}}{Number of "first person" words.}
\item{\code{first_personp}}{Number of "first person plural" words.}
\item{\code{second_person}}{Number of "second person" words.}
\item{\code{second_personp}}{Number of "second person plural" words.}
\item{\code{third_person}}{Number of "third person" words.}
\item{\code{to_be}}{Number of "to be" words.}
\item{\code{prepositions}}{Number of preposition words.}
}
}
\usage{
count_functions
}
\description{
List of all feature counting functions
}
\details{
In this function we refer to "first person", "first person plural" and
so on. This list describes what words are contained in each group.
\describe{
\item{first person}{I, me, myself, my, mine, this.}
\item{first person plural}{we, us, our, ours, these.}
\item{second person}{you, yours, your, yourself.}
\item{second person plural}{he, she, it, its, his, hers.}
\item{third person}{they, them, theirs, their, they're, their's, those, that.}
\item{to be}{am, is, are, was, were, being, been, be, were, be.}
\item{prepositions}{about, below,
excepting, off, toward, above, beneath, on, under, across, from, onto,
underneath, after, between, in, out, until, against, beyond, outside, up,
along, but, inside, over, upon, among, by, past, around, concerning,
regarding, with, at, despite, into, since, within, down, like, through,
without, before, during, near, throughout, behind, except, of, to, for.}
}
}
\keyword{datasets}
