% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfm.R
\name{AIC.tfm}
\alias{AIC.tfm}
\alias{BIC.tfm}
\title{AIC and BIC for Transfer Function Models}
\usage{
\method{AIC}{tfm}(object, ..., k = 2)

\method{BIC}{tfm}(object, ...)
}
\arguments{
\item{object}{A fitted \code{tfm} object.}

\item{...}{Additional \code{tfm} objects for model comparison.}

\item{k}{Numeric. Penalty per parameter. Default is 2 for AIC.
Use \code{k = log(n)} for BIC where n is sample size.}
}
\value{
If one model: numeric value of AIC/BIC. If multiple models:
  data frame with columns df (degrees of freedom) and AIC for each model.
}
\description{
Computes Akaike's Information Criterion (AIC) and Bayesian Information
Criterion (BIC) for transfer function models.
}
\details{
AIC = -2*logLik + k*npar, where npar is the number of parameters.
Lower values indicate better fit penalized for complexity.
}
\examples{
\dontrun{
model1 <- tfm(output, inputs = tf1, noise = noise1)
model2 <- tfm(output, inputs = tf2, noise = noise2)

# Single model AIC
AIC(model1)

# Compare models
AIC(model1, model2)

# BIC
BIC(model1)
}

}
\seealso{
\code{\link{logLik.tfm}}, \code{\link{BIC.tfm}}
}
