% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm.R
\name{logLik.ssm}
\alias{logLik.ssm}
\title{Log-likelihood of a SS model}
\usage{
\method{logLik}{ssm}(object, method = c("exact", "cond"), ...)
}
\arguments{
\item{object}{an object of class \code{\link{ssm}}.}

\item{method}{character. Either "exact" or "conditional" maximum likelihood.}

\item{...}{additional parameters.}
}
\value{
The log-likelihood value.
}
\description{
\code{logLik.ssm} computes the exact or conditional log-likelihood of a state
space model.
}
\examples{

# Local level model
b <- 1
C <- as.matrix(1)
ssm1 <- ssm(Nile, b, C, S = diag(c(irr = 15127.7, lvl = 1453.2)))
logLik(ssm1)
 
}
