% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_methods.R
\name{dataset_rebatch}
\alias{dataset_rebatch}
\title{Rebatch elements from this dataset into batches of specified size.}
\usage{
dataset_rebatch(dataset, batch_size, drop_remainder = FALSE, name = NULL)
}
\arguments{
\item{dataset}{A dataset.}

\item{batch_size}{An integer or integer vector specifying batch sizes. If a
vector, batch sizes cycle through these values in round-robin order.}

\item{drop_remainder}{(Optional.) Logical. If \code{TRUE}, drops the last batch if
it contains fewer elements than \code{batch_size}. Defaults to \code{FALSE}.}

\item{name}{(Optional.) Name for the operation.}
}
\value{
A dataset.
}
\description{
\code{dataset_rebatch(N)} is functionally equivalent to \code{dataset_unbatch()}
followed by \code{dataset_batch(N)}, but it performs only one copy operation,
making it more efficient.
}
\details{
If \code{batch_size} is a vector, it cycles through the provided values in a
round-robin manner to determine the size of each batch.
}
\examples{
\dontrun{
ds <- dataset_range(6) \%>\% dataset_batch(2) \%>\% dataset_rebatch(3)
ds \%>\% as_array_iterator() \%>\% iterate(print)
# [0, 1, 2], [3, 4, 5]

ds <- dataset_range(7) \%>\% dataset_batch(4) \%>\% dataset_rebatch(3)
ds \%>\% as_array_iterator() \%>\% iterate(print)
# [0, 1, 2], [3, 4, 5], [6]

ds <- dataset_range(7) \%>\% dataset_batch(2) \%>\% dataset_rebatch(3, drop_remainder = TRUE)
ds \%>\% as_array_iterator() \%>\% iterate(print)
# [0, 1, 2], [3, 4, 5]

ds <- dataset_range(8) \%>\% dataset_batch(4) \%>\% dataset_rebatch(c(2, 1, 1))
ds \%>\% as_array_iterator() \%>\% iterate(print)
# [0, 1], [2], [3], [4, 5], [6], [7]
}

}
\seealso{
Other dataset methods: 
\code{\link{dataset_batch}()},
\code{\link{dataset_cache}()},
\code{\link{dataset_collect}()},
\code{\link{dataset_concatenate}()},
\code{\link{dataset_decode_delim}()},
\code{\link{dataset_filter}()},
\code{\link{dataset_interleave}()},
\code{\link{dataset_map}()},
\code{\link{dataset_map_and_batch}()},
\code{\link{dataset_padded_batch}()},
\code{\link{dataset_prefetch}()},
\code{\link{dataset_prefetch_to_device}()},
\code{\link{dataset_reduce}()},
\code{\link{dataset_repeat}()},
\code{\link{dataset_shuffle}()},
\code{\link{dataset_shuffle_and_repeat}()},
\code{\link{dataset_skip}()},
\code{\link{dataset_take}()},
\code{\link{dataset_take_while}()},
\code{\link{dataset_window}()}
}
\concept{dataset methods}
