% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_i_qda_linearized.R
\name{param_i_qda_linearized}
\alias{param_i_qda_linearized}
\title{Calculates the function W described in Metodiev et al. (2025).}
\usage{
param_i_qda_linearized(g, sims, meanhat, sigmahat, non_I_set)
}
\arguments{
\item{g}{number indicating the component g}

\item{sims}{n_simul x G x (u+1) array of parameters sampled from
the posterior, where
  n_simul is the number of simulations from the posterior,
  G       is the number of components,
  u       is the number of mixture component parameters
          (parameter u+1 is the mixture weight)}

\item{meanhat}{list of means of component parameters}

\item{sigmahat}{list of covariance matrices of component parameters}

\item{non_I_set}{complement of an independent set of a DAG}
}
\value{
a vector: W evaluated at the posterior sample of component g
}
\description{
Calculates the function W described in Metodiev et al. (2025).
}
\references{
Martin Metodiev, Nicholas J. Irons, Marie Perrot-Dockès,
Pierre Latouche, Adrian E. Raftery. "Easily Computed Marginal Likelihoods
for Multivariate Mixture Models Using the THAMES Estimator."
arXiv preprint arXiv:2504.21812.
}
\keyword{internal}
