% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webexercises.R
\name{quizz}
\alias{quizz}
\title{Create a Quiz}
\usage{
quizz(
  ...,
  render_if = knitr::is_html_output(),
  title = "Quiz",
  show_box = TRUE,
  show_check = TRUE
)
}
\arguments{
\item{...}{Each argument should be a named vector, see Details.}

\item{render_if}{Logical, whether or not to render the output. By default,
this argument uses \code{knitr::is_html_output()}.}

\item{title}{Atomic character, default: 'Quiz'}

\item{show_box}{Logical, whether or not to draw a box around the quiz.
Default: \code{TRUE}}

\item{show_check}{Logical, whether or not to show a button to check answers.
Default: \code{TRUE}}
}
\value{
\code{NULL}, this function is called for its side effect of printing HTML
code using \code{cat()}.
}
\description{
Convenience function for creating a basic quiz in HTML format
from the arguments captured by \code{...}, where the type of each question
is determined automatically from the class of the arguments.
}
\details{
The function renders questions captured by the arguments in \code{...}.
The name of each argument is the text of the question. The value of each
argument determined the question type and its correct answer. The following
types of questions are supported:

\describe{
\item{"\code{torf()}"}{The argument should be a single value of type \code{logical},
e.g.: \code{"The answer to this question is true." = TRUE}}
\item{"\code{mcq()}"}{The argument should be a vector of type \code{character}. The
first element is taken as the correct answer; the order of answers is
randomized. E.g.: \code{"This multiple choice question has three answers." = c("Correct", "Incorrect", "Not sure")}}
\item{"\code{fitb()}"}{The argument should be of type \code{numeric}. If the vector is
atomic, the first element is taken as the correct answer, e.g.:
\code{"Provide an exact floating point answer of 0.81" = 0.81}. If the vector has
two elements, the second element is taken as the tolerance \code{tol},
e.g.: \code{"Here, 0.8 will be correct." = c(0.81, 0.01)}. If the
vector is of type \code{integer}, the tolerance is set to zero, e.g.:
\code{"The answer is 4." = 4L}}
}

Alternatively, \code{...} may contain a single atomic character referring to a
text file that contains the questions, see examples.
}
\examples{
# Quiz from arguments:
invisible(capture.output(theorytools:::quizz(
"The answer to this question is true." = TRUE,
"This multiple choice question has three answers." =
 c(answer = "Correct", "Incorrect", "Not sure"),
"Provide an exact floating point answer of 0.81" = 0.81,
render_if = TRUE
)))
# From a file:
quizz_file <- tempfile()
writeLines(
c("The answer is true. = TRUE",
"The answer is correct = c(answer = \"Correct\", \"Incorrect\", \"Not sure\")",
"The answer is exactly .81 = 0.81",
"But here, .8 is also fine = c(0.81, .01)",
"Write the word 'true' = c('true', 'TRUE')",
"Here, answer exactly 4. = 4L")
, quizz_file)
invisible(capture.output(theorytools:::quizz(quizz_file, render_if = TRUE)))
}
\seealso{
\code{\link[knitr]{is_latex_output}}
\code{\link[webexercises]{mcq}}, \code{\link[webexercises]{torf}}, \code{\link[webexercises]{fitb}}
}
