% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series.R
\encoding{UTF-8}
\name{bde_series_load}
\alias{bde_series_load}
\title{Load a single BdE time-series}
\usage{
bde_series_load(
  series_code,
  series_label = NULL,
  out_format = "wide",
  parse_dates = TRUE,
  parse_numeric = TRUE,
  cache_dir = NULL,
  update_cache = FALSE,
  verbose = FALSE,
  extract_metadata = FALSE
)
}
\arguments{
\item{series_code}{A numeric value (or coercible with \code{\link[base:double]{base::as.double()}})
or vector of time-series code(s), as defined in the field
\verb{Número secuencial} of the corresponding series. See \code{\link[=bde_catalog_load]{bde_catalog_load()}}.}

\item{series_label}{Optional. Character vector or value. Allows specifying a
custom label for the series extracted.}

\item{out_format}{Whether the format should be returned as "long" or "wide".
Possible values are \code{"wide"} or \code{"long"}. See \strong{Value} for details and
section \strong{Examples}.}

\item{parse_dates}{Logical. If \code{TRUE}, the dates will be parsed using
\code{\link[=bde_parse_dates]{bde_parse_dates()}}.}

\item{parse_numeric}{Logical. If \code{TRUE} the columns would be parsed to
double (numeric) values. See \strong{Note}.}

\item{cache_dir}{A path to a cache directory. The directory can also be set
via options with \code{options(bde_cache_dir = "path/to/dir")}.}

\item{update_cache}{Logical. If \code{TRUE}, the requested file will be updated
in the \code{cache_dir}.}

\item{verbose}{Logical \code{TRUE} or \code{FALSE}, display information useful for
debugging.}

\item{extract_metadata}{Logical \code{TRUE/FALSE}. On \code{TRUE} the output is the
metadata of the requested series.}
}
\value{
A \link[tibble:tbl_df-class]{tibble} with a field \code{Date}:
\itemize{
\item With \code{out_format = "wide"}, each series is presented in a separate
column with the name defined by \code{series_label}.
\item With \code{out_format = "long"}, the tibble has two additional columns:
\itemize{
\item \code{serie_name} with the label of each series.
\item \code{serie_value} with the corresponding value.
}
}

\code{"wide"} format is more suitable for exporting to a \code{.csv} file while
\code{"long"} format is more suitable for creating plots with
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}. See also \code{\link[tidyr:pivot_longer]{tidyr::pivot_longer()}} and
\code{\link[tidyr:pivot_wider]{tidyr::pivot_wider()}}.
}
\description{
The series alias is a positional code showing the location (column and/or
row) of the series in the table. However, although it is unique, it is not a
good candidate to be used as the series ID, as it is subject to change. If a
series changes position in the table, its alias will also change.

To ensure series can still be identified, even after these changes, they are
assigned a sequential number (referred to as \code{series_code} in this function).

Note that a single series may appear in different tables, so it can have
several aliases. If you need to search by alias, use
\code{\link[=bde_series_full_load]{bde_series_full_load()}}.
}
\details{
Load a single time-series provided by BdE.
}
\note{
This function attempts to coerce the columns to numbers. For some series, a
warning may be displayed if the parsing fails.
}
\examples{
\dontshow{if (bde_check_access()) withAutoprint(\{ # examplesIf}
\donttest{
# Metadata
bde_series_load(573234, verbose = TRUE, extract_metadata = TRUE)

# Data
bde_series_load(573234, extract_metadata = FALSE)

# Vectorized
bde_series_load(c(573234, 573214),
  series_label = c("US/EUR", "GBP/EUR"),
  extract_metadata = TRUE
)

wide <- bde_series_load(c(573234, 573214),
  series_label = c("US/EUR", "GBP/EUR")
)

# Wide format
wide


# Long format
long <- bde_series_load(c(573234, 573214),
  series_label = c("US/EUR", "GBP/EUR"),
  out_format = "long"
)

long


# Use with ggplot
library(ggplot2)


ggplot(long, aes(Date, serie_value)) +
  geom_line(aes(group = serie_name, color = serie_name)) +
  scale_color_bde_d() +
  theme_tidybde()
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=bde_catalog_load]{bde_catalog_load()}},
\code{\link[=bde_catalog_search]{bde_catalog_search()}}, \code{\link[=bde_indicators]{bde_indicators()}}

Other series: 
\code{\link{bde_series_full_load}()}
}
\concept{series}
