% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_group_stats.R
\name{summarise_group_stats}
\alias{summarise_group_stats}
\title{Summarize Grouped Statistics}
\usage{
summarise_group_stats(
  df,
  group_var,
  values,
  m_functions = c("mean", "sd", "length"),
  replace_na = FALSE,
  remove_na = FALSE
)
}
\arguments{
\item{df}{A data frame or tibble containing the data.}

\item{group_var}{A character vector of column names to group by.}

\item{values}{A character vector of numeric column names to summarize.}

\item{m_functions}{A character vector of functions to apply (e.g., "mean", "sd", "length"). Default is c("mean", "sd", "length").}

\item{replace_na}{Logical. If TRUE, missing values in numeric columns are replaced with 0. Default is FALSE.}

\item{remove_na}{Logical. If TRUE, rows with missing values in group or value columns are removed. Default is FALSE.}
}
\value{
A tibble with grouped and summarized results.
}
\description{
Groups a data frame by one or more variables and summarizes the selected numeric columns using basic statistic functions.
Handles missing values by replacement with zero or removal of rows.
}
\examples{
summarise_group_stats(iris, group_var = "Species",
 values = c("Sepal.Length", "Petal.Width"))
summarise_group_stats(mtcars, 
group_var = c("cyl", "gear"), 
values = c("mpg", "hp"), remove_na = TRUE)

}
