% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment_cptga.R
\name{segment_cptga}
\alias{segment_cptga}
\title{Segment a time series using a genetic algorithm}
\usage{
segment_cptga(x, ...)
}
\arguments{
\item{x}{A time series}

\item{...}{arguments passed to \code{\link[changepointGA:cptga]{changepointGA::cptga()}}}
}
\value{
A \code{tidycptga} object. This is just a \code{\link[changepointGA:cptga]{changepointGA::cptga()}}
object with an additional
slot for \code{data} (the original time series).
}
\description{
Segmenting functions for various genetic algorithms
}
\details{
\code{\link[=segment_cptga]{segment_cptga()}} uses the genetic algorithm in \code{\link[changepointGA:cptga]{changepointGA::cptga()}} to "evolve" a random
set of candidate changepoint sets, using the penalized objective function
specified by \code{penalty_fn}.
By default, the normal \code{meanshift} model is fit (see \code{\link[=fit_meanshift_norm]{fit_meanshift_norm()}})
and the \link{BIC} penalty is applied.
}
\examples{
\donttest{
# Segment a time series using a genetic algorithm
res <- segment_cptga(CET)
summary(res)

# Segment a time series using changepointGA
x <- segment(CET, method = "cptga")
summary(x)
changepoints(x)
}
}
