% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_chart_dense.R
\name{line_chart_dense_custom}
\alias{line_chart_dense_custom}
\title{More customizable version of `line_chart_dense`. User can choose the points to highlight.}
\usage{
line_chart_dense_custom(
  list,
  vector_x,
  vector_y,
  vector_cat,
  series_labels,
  df_numbers = NULL,
  point_cords = NULL,
  interval = "months"
)
}
\arguments{
\item{list}{list of data frames, each representing one series. Data frame should consist of columns:
* containing numeric values from 0 to 100 defining the percentage of distance in one time interval of the point (x - coordinates of the point)
* containing the value of a point  (y - coordinates of the point)
* containing the time interval of the value}

\item{vector_x}{vector containing the names of columns with x - coordinates of the point in the data frames}

\item{vector_y}{vector containing the names of columns with y - coordinates of the point in the data frames}

\item{vector_cat}{vector containing the names of columns with time interval of the point in the data frames}

\item{series_labels}{vector containing names of series to be shown on the plot}

\item{df_numbers}{vector containing index of data frame in the list of a value to be marked}

\item{point_cords}{vector of the same length as df_numbers containing numerical values of indexes in data frame of values to be marked}

\item{interval}{intervals on x axis. The width of the bars depends on this parameter}
}
\value{
object of class tidychart with a character vector containing SVG elements
}
\description{
More customizable version of `line_chart_dense`. User can choose the points to highlight.
}
\examples{

#preparing data frames
data <- data.frame(
xdata = c(1, 60,90, 30, 60, 90, 30, 60, 90, 45,95,45, 95),
ydata = c(5, -10, -15, 11, 16, 18, 25, 22, 18, 10, 8, 23, 28),
catdata = c("Jan","Jan", "Jan", "Feb","Feb", "Feb", "Mar",
"Mar", "Mar", "Apr", "Apr", "May", "May")
)

df <- data.frame(
  xdf = c(1,60,90, 30, 60, 90, 30, 60, 90, 45,95,45, 95),
 ydf = c(25, 22,20, 18, 28, 35,33, 29, 30, 38,31,26, 22),
 catdf = c("Jan","Jan", "Jan", "Feb","Feb", "Feb", "Mar",
  "Mar", "Mar", "Apr", "Apr", "May", "May")
)

#defining the rest of the arguments
list <- list(data, df)
vector_x <- c("xdata", "xdf")
vector_y <- c("ydata", "ydf")
vector_cat <-c("catdata", "catdf")
df_numbers <- c(1,2,2, 1)
point_cords <- c(1, 3, 4, 10)

#generating the svg string
plot<- line_chart_dense_custom(
  list,
  vector_x = c("xdata", "xdf"),
  vector_y = c("ydata", "ydf"),
  vector_cat = c("catdata", "catdf"),
  series_labels = c("Gamma inc.", "Delta inc."),
  df_numbers = df_numbers,
  point_cords = point_cords)

#showing the plot
plot


}
