% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidydp.R
\name{dp_count}
\alias{dp_count}
\title{Differentially Private Count}
\usage{
dp_count(data, epsilon, delta = NULL, group_by = NULL, .budget = NULL)
}
\arguments{
\item{data}{A data frame}

\item{epsilon}{Privacy parameter}

\item{delta}{Privacy parameter (default: NULL, uses Laplace mechanism)}

\item{group_by}{Character vector of column names to group by (optional)}

\item{.budget}{Optional privacy budget object to track expenditure}
}
\value{
Data frame with (possibly grouped) counts
}
\description{
Computes a differentially private count of rows, optionally grouped by specified columns.
}
\examples{
data <- data.frame(city = c("NYC", "LA", "NYC", "LA", "NYC"),
                   age = c(25, 30, 35, 40, 45))
# Overall count
dp_count(data, epsilon = 0.1)

# Grouped count
data \%>\% dp_count(epsilon = 0.1, group_by = "city")
}
