% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getpklips.R
\name{getpklips}
\alias{getpklips}
\title{`getpklips()' is used to obtain data.frame for KLIPS (household member survey)}
\usage{
getpklips(
  path,
  year,
  datatype = c("stata", "spss", "sas", "xlsx"),
  klipsvars = c("0101", "0107"),
  outvars = c("gender", "age")
)
}
\arguments{
\item{path}{A string vector specifying folder containing KLIPS household member survey data}

\item{year}{an integer vector  specifying the years from 1998 to 2023 that the user wants to include in the dataframe.}

\item{datatype}{A string vector specifying the format of the raw data you want to convert to a data frame ("spss", "sas", "stata", "excel")}

\item{klipsvars}{A string vector specifying the variables in the raw data that you want to convert to a data frame ("0101", "0107")}

\item{outvars}{A string vector specifying the variable names of converted data ("gender", "age")}
}
\value{
A data frame containing klips household member data with the specified years and variables.
\itemize{
\item \code{getpklips()} returns an integer dataframe with two and more columns and
rows for each respondent. The first column, \code{pid},
refers to the respondent id number, and the last column, \code{year},
refers to the year that the user wants to include in the dataframe.
}
}
\description{
`getpklips()' is used to obtain data.frame for KLIPS (household member survey)
}
\examples{

path <- system.file("extdata", package = "tidyklips")
df <- getpklips(path = path, year = 1998, datatype = "stata")
df \%>\%
  dplyr::group_by(year, gender) \%>\%
  dplyr::summarise(count = dplyr::n()) \%>\%
  dplyr::mutate(proportion = count / sum(count))


}
