% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supervised-xgboost.R
\name{tl_tune_xgboost}
\alias{tl_tune_xgboost}
\title{Tune XGBoost hyperparameters}
\usage{
tl_tune_xgboost(
  data,
  formula,
  is_classification = FALSE,
  param_grid = NULL,
  cv_folds = 5,
  early_stopping_rounds = 10,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{A data frame containing the training data}

\item{formula}{A formula specifying the model}

\item{is_classification}{Logical indicating if this is a classification problem}

\item{param_grid}{Named list of parameter values to try}

\item{cv_folds}{Number of cross-validation folds (default: 5)}

\item{early_stopping_rounds}{Early stopping rounds (default: 10)}

\item{verbose}{Logical indicating whether to print progress (default: TRUE)}

\item{...}{Additional arguments}
}
\value{
A list with the best model and tuning results
}
\description{
Tune XGBoost hyperparameters
}
