% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_azure_openai.R
\name{azure_openai_embedding}
\alias{azure_openai_embedding}
\title{Generate Embeddings Using OpenAI API on Azure}
\usage{
azure_openai_embedding(
  .input,
  .deployment = "text-embedding-3-small",
  .endpoint_url = Sys.getenv("AZURE_ENDPOINT_URL"),
  .api_version = "2023-05-15",
  .truncate = TRUE,
  .timeout = 120,
  .dry_run = FALSE,
  .max_tries = 3
)
}
\arguments{
\item{.input}{A character vector of texts to embed or an \code{LLMMesssage}object}

\item{.deployment}{The embedding model identifier (default: "text-embedding-3-small").}

\item{.endpoint_url}{Base URL for the API (default:  Sys.getenv("AZURE_ENDPOINT_URL")).}

\item{.api_version}{What API-Version othe Azure OpenAI API should be used (default: "2023-05-15")}

\item{.truncate}{Whether to truncate inputs to fit the model's context length (default: TRUE).}

\item{.timeout}{Timeout for the API request in seconds (default: 120).}

\item{.dry_run}{If TRUE, perform a dry run and return the request object.}

\item{.max_tries}{Maximum retry attempts for requests (default: 3).}
}
\value{
A tibble with two columns: \code{input} and \code{embeddings}.
The \code{input} column contains the texts sent to embed, and the \code{embeddings} column
is a list column where each row contains an embedding vector of the sent input.
}
\description{
Generate Embeddings Using OpenAI API on Azure
}
