% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_mistral.R
\name{mistral_chat}
\alias{mistral_chat}
\title{Send LLMMessage to Mistral API}
\usage{
mistral_chat(
  .llm,
  .model = "mistral-large-latest",
  .frequency_penalty = NULL,
  .logit_bias = NULL,
  .presence_penalty = NULL,
  .seed = NULL,
  .stop = NULL,
  .stream = FALSE,
  .temperature = 0.7,
  .top_p = 1,
  .min_tokens = NULL,
  .max_tokens = NULL,
  .json_schema = NULL,
  .safe_prompt = FALSE,
  .timeout = 120,
  .max_tries = 3,
  .dry_run = FALSE,
  .verbose = FALSE,
  .tools = NULL,
  .tool_choice = NULL
)
}
\arguments{
\item{.llm}{An \code{LLMMessage} object.}

\item{.model}{The model identifier to use (default: \code{"mistral-large-latest"}).}

\item{.frequency_penalty}{Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency.}

\item{.logit_bias}{A named list modifying the likelihood of specified tokens appearing in the completion.}

\item{.presence_penalty}{Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far.}

\item{.seed}{If specified, the system will make a best effort to sample deterministically.}

\item{.stop}{Up to 4 sequences where the API will stop generating further tokens.}

\item{.stream}{If set to TRUE, the answer will be streamed to console as it comes (default: FALSE).}

\item{.temperature}{What sampling temperature to use, between 0 and 2. Higher values make the output more random.}

\item{.top_p}{An alternative to sampling with temperature, called nucleus sampling.}

\item{.min_tokens}{The minimum number of tokens to generate in the completion. Must be \verb{>= 0} (optional).}

\item{.max_tokens}{An upper bound for the number of tokens that can be generated for a completion.}

\item{.json_schema}{A JSON schema object provided by tidyllm schema or ellmer schemata.}

\item{.safe_prompt}{Whether to inject a safety prompt before all conversations (default: \code{FALSE}).}

\item{.timeout}{When should our connection time out in seconds (default: \code{120}).}

\item{.max_tries}{Maximum retries to peform request}

\item{.dry_run}{If \code{TRUE}, perform a dry run and return the request object (default: \code{FALSE}).}

\item{.verbose}{Should additional information be shown after the API call? (default: \code{FALSE})}

\item{.tools}{Either a single TOOL object or a list of TOOL objects representing the available functions for tool calls.}

\item{.tool_choice}{A character string specifying the tool-calling behavior; valid values are "none", "auto", or "required".}
}
\value{
Returns an updated \code{LLMMessage} object.
}
\description{
Send LLMMessage to Mistral API
}
