% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm.R
\name{norm_generic}
\alias{norm_generic}
\title{Generic Normalization Procedure}
\usage{
norm_generic(
  .data,
  ...,
  .by = NULL,
  .by_formant = FALSE,
  .by_token = FALSE,
  .L = 0,
  .S = 1,
  .pre_trans = function(x) x,
  .post_trans = function(x) x,
  .drop_orig = FALSE,
  .keep_params = FALSE,
  .names = "{.formant}_n",
  .silent = opt("tidynorm.silent"),
  .call = caller_env()
)
}
\arguments{
\item{.data}{A data frame containing vowel formant data}

\item{...}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} One or more unquoted
expressions separated by commas. These should target the vowel formant
data columns.}

\item{.by}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} A selection of
columns to group by. Typically a column of speaker IDs.}

\item{.by_formant}{Whether or not the normalization method is formant
intrinsic.}

\item{.by_token}{Whether or not the normalization method is vowel intrinsic}

\item{.L}{An expression defining the location parameter.
See Details for more information.}

\item{.S}{An expression defining the scale parameter.
See Details for more information.}

\item{.pre_trans}{A function to apply to formant values before normalization.}

\item{.post_trans}{A function to apply to formant values after normalization.}

\item{.drop_orig}{Whether or not to drop the original formant data columns.}

\item{.keep_params}{Whether or not to keep the Location (\verb{*_.L}) and Scale
(\verb{*_.S}) normalization parameters}

\item{.names}{A \code{\link[glue:glue]{glue::glue()}} expression for naming the normalized
data columns. The \code{"{.formant}"} portion corresponds to the name of the original
formant columns.}

\item{.silent}{Suppress normalization information messages when running a \verb{norm_*()} function. (Defaults to \code{FALSE}, overwritable using option 'tidynorm.silent' or environment variable 'R_TIDYNORM_TIDYNORM_SILENT')}

\item{.call}{Used for internal purposes.}
}
\value{
A data frame of normalized formant values
}
\description{
This is a generic normalization procedure with which
you can create your own normalization method.
}
\details{
The following \verb{norm_*} procedures are built on top of \code{norm_generic()}.
\itemize{
\item \link{norm_lobanov}
\item \link{norm_nearey}
\item \link{norm_deltaF}
\item \link{norm_wattfab}
\item \link{norm_barkz}
}
\subsection{Location and Scale expressions}{

All normalization procedures built on \link{norm_generic} produce normalized
formant values (\eqn{\hat{F}}) by subtracting a location parameter
(\eqn{L}) and dividing by a scale parameter (\eqn{S}).

\deqn{
\hat{F} = \frac{F-L}{S}
}

The expressions for calculating \eqn{L} and \eqn{S} can be
passed to \code{.L} and \code{.S}, respectively. Available values for
these expressions are

\describe{
\item{\code{.formant}}{The original formant value}
\item{\code{.formant_num}}{The number of the formant. (e.g. 1 for F1, 2 for F2 etc)}
}

Along with any data columns from your original data.
}

\subsection{Pre and Post normalization transforms}{

To apply any transformations before or after normalization,
you can pass a function to \code{.pre_trans} and \code{.post_trans}.
}

\subsection{Formant In/Extrinsic Normalization}{

If \code{.by_formant} is \code{TRUE}, normalization will be formant intrinsic.
If \code{.by_formant} is \code{FALSE}, normalization will be formant extrinsic.
}

\subsection{Token In/Extrinsic Normalization}{

If \code{.by_token} is \code{TRUE}, normalization will be token intrinsic.
If \code{.by_token} is \code{FALSE}, normalization will be token extrinsic.
}
}
\examples{
library(tidynorm)
library(dplyr)

speaker_data |>
  norm_generic(
    F1:F3,
    .by = speaker,
    .by_formant = TRUE,
    .L = median(.formant, na.rm = TRUE),
    .S = mad(.formant, na.rm = TRUE),
    .drop_orig = TRUE,
    .names = "{.formant}_mad"
  )
}
