% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dct.R
\name{reframe_with_idct}
\alias{reframe_with_idct}
\title{Reframe with IDCT}
\usage{
reframe_with_idct(
  .data,
  ...,
  .token_id_col = NULL,
  .by = NULL,
  .param_col = NULL,
  .n = 20,
  .rate = FALSE,
  .accel = FALSE
)
}
\arguments{
\item{.data}{A data frame}

\item{...}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} One or more unquoted
expressions separated by commas. These should target the vowel formant.}

\item{.token_id_col}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} The token ID column.}

\item{.by}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} A grouping column.}

\item{.param_col}{A column identifying the DCT parameter number}

\item{.n}{The size of the outcome of the IDCT}

\item{.rate}{Whether or not to include the rate of change of signal.}

\item{.accel}{Whether or not to include acceleration of signal.}
}
\value{
A data frame with the IDCT of the targeted columns along with an
additional \code{.time} column.

\describe{
\item{.time}{A column from 1 to \code{.n} by token}
}
}
\description{
Reframe data columns using the Inverse Discrete Cosine Transform
}
\details{
This will apply the Inverse Discrete Cosine Transform to the targeted
columns. See \link{idct}.
\subsection{Identifying tokens}{

The IDCT only works on a by-token basis, so there must be a column that
uniquely identifies (or, in combination with a \code{.by} grouping, uniquely
identifies) each individual token. This column should be passed to
\code{.token_id_col}.
}

\subsection{Size of the output}{

The output of the IDCT can be arbitrarily long as defined by the \code{.n}
argument. \code{.n} can either be an integer, or an unqoted data column.
}

\subsection{The Parameter Column}{

The order of the DCT parameters is crucially important. The optional
\code{.param_col} will ensure the data is properly arranged.
}
}
\examples{
library(tidynorm)
library(dplyr)
ggplot2_inst <- require(ggplot2)

speaker_small <- filter(
  speaker_tracks,
  id == 0
)

speaker_dct <- speaker_small |>
  reframe_with_dct(
    F1:F3,
    .by = speaker,
    .token_id_col = id,
    .time_col = t,
    .order = 5
  )

speaker_idct <- speaker_dct |>
  reframe_with_idct(
    F1:F3,
    .by = speaker,
    .token_id_col = id,
    .param_col = .param,
    .n = 20
  )

if (ggplot2_inst) {
  speaker_small |>
    mutate(
      .by = c(speaker, id),
      time_index = row_number()
    ) |>
    ggplot(
      aes(
        time_index, F1
      )
    ) +
    geom_point() +
    labs(
      title = "Original Data"
    )
}

if (ggplot2_inst) {
  speaker_idct |>
    ggplot(
      aes(
        .time, F1
      )
    ) +
    geom_point() +
    labs(
      title = "DCT Smooth Data"
    )
}
}
