% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_levels.R
\name{reverse_x_axis_levels}
\alias{reverse_x_axis_levels}
\alias{reverse_y_axis_levels}
\alias{reverse_color_levels}
\alias{reverse_x_axis_labels}
\alias{reverse_y_axis_labels}
\alias{reverse_color_labels}
\title{Reverse axis or color levels}
\usage{
reverse_x_axis_levels(plot)

reverse_y_axis_levels(plot)

reverse_color_levels(plot)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}
}
\value{
A \code{tidyplot} object.
}
\description{
Reverse axis or color levels
}
\examples{
# Before adjustments
study |>
  tidyplot(x = treatment, y = score) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar()

# Reverse x-axis levels
study |>
  tidyplot(x = treatment, y = score) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  reverse_x_axis_levels()

# Before adjustments
study |>
  tidyplot(x = score, y = treatment) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar()

# Reverse y-axis levels
study |>
  tidyplot(x = score, y = treatment) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  reverse_y_axis_levels()

# Before adjustment
study |>
  tidyplot(x = group, y = score, color = dose) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar()

# Reverse color levels
study |>
  tidyplot(x = group, y = score, color = dose) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  reverse_color_levels()

}
