% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicates.R
\name{duplicates}
\alias{duplicates}
\title{Keep non-unique rows in a data frame}
\usage{
duplicates(.data, ..., .keep_all = TRUE)
}
\arguments{
\item{.data}{A data.frame.}

\item{...}{Optional variables to use when determining non-uniqueness.
If omitted, will use all variables in the data frame.}

\item{.keep_all}{A flag specifying whether to keep all variables in .data.}
}
\value{
The original data frame with only non-unique rows.
}
\description{
Keeps only non-unique rows within a data frame.
}
\examples{
data <- tibble::tibble(x = c(1, 2, 1, 1), y = c(1, 1, 1, 5))

duplicates(data)
duplicates(data, x)
duplicates(data, y)
duplicates(data, x, y)
duplicates(data, y, .keep_all = FALSE)
}
