% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loci_hwe.R
\name{loci_hwe}
\alias{loci_hwe}
\alias{loci_hwe.tbl_df}
\alias{loci_hwe.vctrs_bigSNP}
\alias{loci_hwe.grouped_df}
\title{Test Hardy-Weinberg equilibrium at each locus}
\usage{
loci_hwe(.x, .col = "genotypes", ...)

\method{loci_hwe}{tbl_df}(.x, .col = "genotypes", mid_p = TRUE, ...)

\method{loci_hwe}{vctrs_bigSNP}(.x, .col = "genotypes", mid_p = TRUE, ...)

\method{loci_hwe}{grouped_df}(
  .x,
  .col = "genotypes",
  mid_p = TRUE,
  n_cores = bigstatsr::nb_cores(),
  block_size = bigstatsr::block_size(nrow(.x), 1),
  type = c("tidy", "list", "matrix"),
  ...
)
}
\arguments{
\item{.x}{a vector of class \code{vctrs_bigSNP} (usually the \code{genotypes} column of
a \code{\link{gen_tibble}} object), or a \code{\link{gen_tibble}}.}

\item{.col}{the column to be used when a tibble (or grouped tibble is passed
directly to the function). This defaults to "genotypes" and can only take
that value. There is no need for the user to set it, but it is included to
resolve certain tidyselect operations.}

\item{...}{not used.}

\item{mid_p}{boolean on whether the mid-p value should be computed. Default
is TRUE, as in PLINK.}

\item{n_cores}{number of cores to be used, it defaults to
\code{\link[bigstatsr:reexports]{bigstatsr::nb_cores()}}}

\item{block_size}{maximum number of loci read at once.}

\item{type}{type of object to return, if using grouped method. One of "tidy",
"list", or "matrix". Default is "tidy".}
}
\value{
a vector of probabilities from HWE exact test, one per locus
}
\description{
Return the p-value from an exact test of HWE.
}
\details{
This function uses the original C++ algorithm from PLINK 1.90.
}
\examples{
\dontshow{
data.table::setDTthreads(2)
RhpcBLASctl::blas_set_num_threads(2)
RhpcBLASctl::omp_set_num_threads(2)
}
example_gt <- load_example_gt("gen_tbl")

# For HWE
example_gt \%>\% loci_hwe()

# For loci_hwe per locus per population, use reframe
example_gt \%>\%
  group_by(population) \%>\%
  reframe(loci_hwe = loci_hwe(genotypes))

}
\author{
the C++ algorithm was written by Christopher Chang for PLINK 1.90,
based on original code by Jan Wigginton (the code was released under GPL3).
}
