% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/answer_as_list.R
\name{answer_as_list}
\alias{answer_as_list}
\title{Make LLM answer as a list of items}
\usage{
answer_as_list(
  prompt,
  item_name = "item",
  item_explanation = NULL,
  n_unique_items = NULL,
  list_mode = c("bullet", "comma")
)
}
\arguments{
\item{prompt}{A single string or a \code{\link[=tidyprompt]{tidyprompt()}} object}

\item{item_name}{(optional) Name of the items in the list}

\item{item_explanation}{(optional) Additional explanation of what an item
should be. Item explanation should be a single string. It will be
appended after the list instruction}

\item{n_unique_items}{(optional) Number of unique items required in the list}

\item{list_mode}{(optional) Mode of the list. Either "bullet" or "comma".
"bullet mode expects items to be listed with "--" before each item, with a
new line for each item (e.g., "-- item1\\n-- item2\\n-- item3").
"comma" mode expects items to be listed with a number and a period before
(e.g., "1. item1, 2. item2, 3. item3"). "comma" mode may be easier for
smaller LLMs to use}
}
\value{
A \code{\link[=tidyprompt]{tidyprompt()}} with an added \code{\link[=prompt_wrap]{prompt_wrap()}} which
will ensure that the LLM response is a list of items
}
\description{
Make LLM answer as a list of items
}
\examples{
\dontrun{
  "What are some delicious fruits?" |>
    answer_as_list(item_name = "fruit", n_unique_items = 5) |>
    send_prompt()
  # --- Sending request to LLM provider (llama3.1:8b): ---
  # What are some delicious fruits?
  #
  # Respond with a list, like so:
  #   -- <<fruit 1>>
  #   -- <<fruit 2>>
  #   etc.
  # The list should contain 5 unique items.
  # --- Receiving response from LLM provider: ---
  # Here's the list of delicious fruits:
  #   -- Strawberries
  #   -- Pineapples
  #   -- Mangoes
  #   -- Blueberries
  #   -- Pomegranates
  # [[1]]
  # [1] "Strawberries"
  #
  # [[2]]
  # [1] "Pineapples"
  #
  # [[3]]
  # [1] "Mangoes"
  #
  # [[4]]
  # [1] "Blueberries"
  #
  # [[5]]
  # [1] "Pomegranates"
}

}
\seealso{
\code{\link[=answer_as_named_list]{answer_as_named_list()}}

Other pre_built_prompt_wraps: 
\code{\link{add_image}()},
\code{\link{add_text}()},
\code{\link{answer_as_boolean}()},
\code{\link{answer_as_category}()},
\code{\link{answer_as_integer}()},
\code{\link{answer_as_json}()},
\code{\link{answer_as_multi_category}()},
\code{\link{answer_as_named_list}()},
\code{\link{answer_as_regex_match}()},
\code{\link{answer_as_text}()},
\code{\link{answer_by_chain_of_thought}()},
\code{\link{answer_by_react}()},
\code{\link{answer_using_r}()},
\code{\link{answer_using_sql}()},
\code{\link{answer_using_tools}()},
\code{\link{prompt_wrap}()},
\code{\link{quit_if}()},
\code{\link{set_system_prompt}()}

Other answer_as_prompt_wraps: 
\code{\link{answer_as_boolean}()},
\code{\link{answer_as_category}()},
\code{\link{answer_as_integer}()},
\code{\link{answer_as_json}()},
\code{\link{answer_as_multi_category}()},
\code{\link{answer_as_named_list}()},
\code{\link{answer_as_regex_match}()},
\code{\link{answer_as_text}()}
}
\concept{answer_as_prompt_wraps}
\concept{pre_built_prompt_wraps}
