% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calib_class_thresh.R
\name{calib_class_thresh}
\alias{calib_class_thresh}
\title{Calibrate class thresholds}
\usage{
calib_class_thresh(object, class_thresh, metric_thresh = NULL)
}
\arguments{
\item{object}{an simple_ensemble object}

\item{class_thresh}{probability threshold used to convert probabilities into
classes. It can be a number (between 0 and 1), or a character metric
(currently "tss_max", "kap_max" or "sensitivity"). For sensitivity, an
additional target value is passed along as a second element of a vector,
e.g. c("sensitivity",0.8).}

\item{metric_thresh}{a vector of length 2 giving a metric and its threshold,
which will be used to prune which models in the ensemble will be used for
the prediction. The 'metrics' need to have been computed when the workflow
was tuned. The metric's threshold needs to match the value used during
prediction. Examples are c("accuracy",0.8) or c("boyce_cont",0.7).}
}
\value{
a \link{simple_ensemble} object with an additional attribute
\code{class_thresholds}, which is a tibble with columns:
\itemize{
\item \code{class_thresh}: the value passed to \code{class_thresh}
\item \code{metric_thresh}: the value passed to \code{metric_thresh}
\item \code{fun}: the aggregating function used to combine predictions
\item \code{optim_value}: the optimal threshold for the given combination of
\code{class_thresh}, \code{metric_thresh} and \code{fun}
}
}
\description{
Calibrate the probability thresholds that convert probabilities into classes
for a simple ensemble object. This is done by generating predictions for the
training data, and then optimizing the threshold according to the metric
given in \code{class_thresh}. The calibration depends on how the ensemble is
pruned, which is defined by \code{metric_thresh}, and how predictions are
combined. \code{calib_class_threshold} considers the four possible combining
options available via the parameter \code{fun} in \link{predict.simple_ensemble}; note
that the weighted functions \code{weighted_mean} and \code{weighted_median} use weights
based on the metric used to tune the ensemble, and so they might make little
sense if used in conjunction with a different metric. The updated simple
ensemble contains information on the optimal thresholds for the given
combination of \code{class_thresh}, \code{metric_thresh} and \code{fun}, and these will be
used when predicting classes with \link{predict.simple_ensemble}.
}
\examples{
\dontshow{if (rlang::is_installed("earth")) withAutoprint(\{ # examplesIf}
test_ens <- simple_ensemble() \%>\%
  add_member(two_class_res[1:3, ], metric = "roc_auc")
test_ens <- calib_class_thresh(test_ens, class_thresh = "tss_max")
test_ens <- calib_class_thresh(test_ens, class_thresh = "kap_max")
test_ens <- calib_class_thresh(test_ens, class_thresh = c("sens", 0.9))
collect_class_thresh(test_ens)
\dontshow{\}) # examplesIf}
}
\keyword{predict}
