% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidysmd.R
\name{tidy_smd}
\alias{tidy_smd}
\title{Tidy Standardized Mean Differences}
\usage{
tidy_smd(
  .df,
  .vars,
  .group,
  .wts = NULL,
  include_observed = TRUE,
  include_unweighted = NULL,
  na.rm = FALSE,
  gref = 1L,
  std.error = FALSE,
  make_dummy_vars = FALSE
)
}
\arguments{
\item{.df}{A data frame}

\item{.vars}{Variables for which to calculate SMD}

\item{.group}{Grouping variable}

\item{.wts}{Variables to use for weighting the SMD calculation. These can be,
for instance, propensity score weights or a binary indicator signaling
whether or not a participant was included in a matching algorithm.}

\item{include_observed}{Logical. If using \code{.wts}, also calculate the
unweighted SMD?}

\item{include_unweighted}{Deprecated. Please use \code{include_observed}.}

\item{na.rm}{Remove \code{NA} values from \code{x}? Defaults to \code{FALSE}.}

\item{gref}{an integer indicating which level of \code{g} to use as the reference
group. Defaults to \code{1}.}

\item{std.error}{Logical indicator for computing standard errors using
\code{\link[smd]{compute_smd_var}}. Defaults to \code{FALSE}.}

\item{make_dummy_vars}{Logical. Transform categorical variables to dummy
variables using \code{model.matrix()}? By default, \link[smd:smd]{smd::smd} uses a summary
value based on the Mahalanobis distance distance to approximate the SMD of
categorical variables. An alternative approach is to transform categorical
variables to a set of dummy variables.}
}
\value{
a tibble
}
\description{
\code{tidy_smd()} calculates the standardized mean difference (SMD) for variables
in a dataset between groups. Optionally, you may also calculate weighted
SMDs. \code{tidy_smd()} wraps \code{smd::smd()}, returning a tidy dataframe with the
columns \code{variable}, \code{method}, and \code{smd}, as well as fourth column the
contains the level of \code{.group} the SMD represents. You may also supply
multiple weights to calculate multiple weighted SMDs, useful when comparing
different types of weights. Additionally, the \code{.wts} argument supports
matched datasets where the variable supplied to \code{.wts} is an binary variable
indicating whether the row was included in the match. If you're using
MatchIt, the helper function \code{\link[=bind_matches]{bind_matches()}} will bind these indicators to
the original dataset,  making it easier to compare across matching
specifications.
}
\examples{

tidy_smd(nhefs_weights, c(age, education, race), .group = qsmk)
tidy_smd(nhefs_weights, c(age, education), .group = qsmk, std.error = TRUE)

tidy_smd(
  nhefs_weights,
  c(age, race, education),
  .group = qsmk,
  .wts = c(w_ate, w_att, w_atm)
)
}
