% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_tibble-Spat.R
\name{as_tibble.Spat}
\alias{as_tibble.Spat}
\alias{as_tibble.SpatRaster}
\alias{as_tibble.SpatVector}
\title{Coerce a \code{SpatVector} or \code{SpatRaster} object to data frames}
\usage{
\method{as_tibble}{SpatRaster}(x, ..., xy = FALSE, na.rm = FALSE, .name_repair = "unique")

\method{as_tibble}{SpatVector}(x, ..., geom = NULL, .name_repair = "unique")
}
\arguments{
\item{x}{A \code{SpatRaster} created with \code{\link[terra:rast]{terra::rast()}} or a \code{SpatVector}
created with \code{\link[terra:vect]{terra::vect()}}.}

\item{...}{Arguments passed on to \code{\link[terra:as.data.frame]{terra::as.data.frame()}}.}

\item{xy}{logical. If \code{TRUE}, the coordinates of each raster cell are included}

\item{na.rm}{logical. If \code{TRUE}, cells that have a \code{NA} value in at least one layer are removed. If the argument is set to \code{NA} only cells that have \code{NA} values in all layers are removed}

\item{.name_repair}{Treatment of problematic column names:
\itemize{
\item \code{"minimal"}: No name repair or checks, beyond basic existence.
\item \code{"unique"}: Make sure names are unique and not empty.
\item \code{"check_unique"}: (default value), no name repair, but check they are
\code{unique}.
\item \code{"universal"}: Make the names \code{unique} and syntactic.
\item a function: apply custom name repair (e.g., \code{.name_repair = make.names}
for names in the style of base \strong{R}).
\item A purrr-style anonymous function, see \code{\link[rlang:as_function]{rlang::as_function()}}.
}}

\item{geom}{character or NULL. If not NULL, either "WKT" or "HEX", to get the geometry included in Well-Known-Text or hexadecimal notation. If \code{x} has point geometry, it can also be "XY" to add the coordinates of each point}
}
\value{
A \code{\link[tibble:tibble]{tibble}}.
}
\description{
\code{\link[=as_tibble]{as_tibble()}} methods for \code{SpatRaster} and \code{SpatVector} objects.
}
\section{\CRANpkg{terra} equivalent}{


\code{\link[terra:as.data.frame]{terra::as.data.frame()}}
}

\section{Methods}{


Implementation of the \strong{generic} \code{\link[tibble:as_tibble]{tibble::as_tibble()}} function.
\subsection{\code{SpatRaster} and \code{SpatVector}}{

The tibble is returned with an attribute including the crs of the initial
object in WKT format (see \code{\link[=pull_crs]{pull_crs()}}).
}
}

\section{About layer/column names}{


When coercing \code{SpatRaster} objects to data frames, \code{x} and \code{y} names are
reserved for geographic coordinates of each cell of the \code{SpatRaster} It
should be also noted that \CRANpkg{terra} allows layers with duplicated
names.

In the process of coercing a \code{SpatRaster} to a tibble, \CRANpkg{tidyterra}
may rename the layers of your \code{SpatRaster} for overcoming this issue.
Specifically, layers may be renamed on the following cases:
\itemize{
\item Layers with duplicated names.
\item When coercing to a tibble, if \code{xy = TRUE}, layers named \code{x} or \code{y} would be
renamed.
\item When working with tidyverse methods (i.e. \code{\link[=filter.SpatRaster]{filter.SpatRaster()}}), the
latter would happen as well.
}

\CRANpkg{tidyterra} would display a message informing of the changes on the
names of the layer.

The same issue happens for \code{SpatVector} with names \code{geometry} (when
\code{geom = c("WKT", "HEX")}) and \code{x}, \code{y} (when \code{geom = "XY"}). These are
reserved names representing the geometry of the \code{SpatVector} (see
\code{\link[terra:as.data.frame]{terra::as.data.frame()}}). If \code{geom} is not \code{NULL} then the logic described
for \code{SpatRaster} would apply as well for the columns of the \code{SpatVector}.
}

\examples{

library(terra)
# SpatRaster
f <- system.file("extdata/cyl_temp.tif", package = "tidyterra")
r <- rast(f)

as_tibble(r, na.rm = TRUE)

as_tibble(r, xy = TRUE)

# SpatVector

f <- system.file("extdata/cyl.gpkg", package = "tidyterra")
v <- vect(f)

as_tibble(v)

}
\seealso{
\code{\link[tibble:as_tibble]{tibble::as_tibble()}}, \code{\link[terra:as.data.frame]{terra::as.data.frame()}}

Coercing objects:
\code{\link{as_coordinates}()},
\code{\link{as_sf}()},
\code{\link{as_spatraster}()},
\code{\link{as_spatvector}()},
\code{\link{fortify.Spat}}
}
\concept{coerce}
\concept{tibble.methods}
