% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hypsometric_tints_db}
\alias{hypsometric_tints_db}
\title{Hypsometric palettes database}
\format{
A \link[tibble:tbl_df-class]{tibble} of 1102 rows and
6 columns. with the following fields:

\describe{
\item{pal}{ Name of the palette.}
\item{limit}{Recommended elevation limit (in meters) for each color.}
\item{r}{Value of the red channel (RGB color mode).}
\item{g}{Value of the green channel (RGB color mode).}
\item{b}{Value of the blue channel (RGB color mode).}
\item{hex}{ Hex code of the color.}
}
}
\source{
cpt-city: \url{http://seaviewsensing.com/pub/cpt-city/}.
}
\description{
A \link[tibble:tbl_df-class]{tibble} including the color map of
33 gradient palettes. All the
palettes includes also a definition of colors limits in terms of elevation
(meters), that can be used with \code{\link[ggplot2:scale_gradient]{ggplot2::scale_fill_gradientn()}}.
}
\examples{
\donttest{
data("hypsometric_tints_db")

hypsometric_tints_db

# Select a palette
wikicols <- hypsometric_tints_db |>
  filter(pal == "wiki-2.0")

f <- system.file("extdata/asia.tif", package = "tidyterra")
r <- terra::rast(f)

library(ggplot2)

p <- ggplot() +
  geom_spatraster(data = r) +
  labs(fill = "elevation")

p +
  scale_fill_gradientn(colors = wikicols$hex)

# Use with limits
p +
  scale_fill_gradientn(
    colors = wikicols$hex,
    values = scales::rescale(wikicols$limit),
    limit = range(wikicols$limit)
  )
}
}
\seealso{
\code{\link[=scale_fill_hypso_c]{scale_fill_hypso_c()}}

Other datasets: 
\code{\link{cross_blended_hypsometric_tints_db}},
\code{\link{grass_db}},
\code{\link{princess_db}},
\code{\link{volcano2}}
}
\concept{datasets}
