% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_water.R
\name{define_water_df}
\alias{define_water_df}
\title{Apply \code{define_water} within a dataframe and output a column of \code{water} class to be chained to other tidywater functions}
\usage{
define_water_df(
  df,
  output_water = "defined",
  pluck_cols = FALSE,
  water_prefix = TRUE
)
}
\arguments{
\item{df}{a data frame containing columns with all the desired parameters with column names matching argument names in define_water}

\item{output_water}{name of the output column storing updated parameters with the class, water. Default is "defined".}

\item{pluck_cols}{Extract primary water slots (ph, alk, doc, uv254) into new numeric columns for easy access. Default to FALSE.}

\item{water_prefix}{Append the output_water name to the start of the plucked columns. Default is TRUE.}
}
\value{
A data frame containing a water class column.
}
\description{
This function allows \link{define_water} to be added to a piped data frame.
Its output is a \code{water} class, and can therefore be chained with "downstream" tidywater functions.
}
\examples{
\donttest{
example_df <- water_df \%>\%
  define_water_df() \%>\%
  balance_ions_df()

example_df <- water_df \%>\%
  define_water_df(output_water = "This is a column of water") \%>\%
  balance_ions_df(input_water = "This is a column of water")
}

}
\seealso{
\link{define_water}
}
